<?php
session_start();

define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_NAME', 'hgzy_game');

// কানেকশন তৈরি
try {
    $pdo = new PDO(
        "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
        DB_USER,
        DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ]
    );
} catch (PDOException $e) {
    die("ডাটাবেস কানেকশন ব্যর্থ: " . $e->getMessage());
}

// ফাংশন: ইউজার ডাটা পাওয়া
function getUserData($uid) {
    global $pdo;
    $stmt = $pdo->prepare("SELECT * FROM users WHERE uid = ?");
    $stmt->execute([$uid]);
    return $stmt->fetch();
}

// ফাংশন: ইউজার আইডি দিয়ে ডাটা পাওয়া
function getUserById($id) {
    global $pdo;
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$id]);
    return $stmt->fetch();
}

// ফাংশন: UIID দিয়ে ইউজার খুঁজা
function getUserByUiId($uiId) {
    global $pdo;
    $stmt = $pdo->prepare("SELECT * FROM users WHERE uiId = ?");
    $stmt->execute([$uiId]);
    return $stmt->fetch();
}

// ফাংশন: ফোন নাম্বার দিয়ে ইউজার খুঁজা
function getUserByPhone($phone) {
    global $pdo;
    $stmt = $pdo->prepare("SELECT * FROM users WHERE phone = ?");
    $stmt->execute([$phone]);
    return $stmt->fetch();
}

// ফাংশন: লগইন চেক
function isLoggedIn() {
    return isset($_SESSION['user_uid']);
}

// ফাংশন: কারেন্ট ইউজার
function getCurrentUser() {
    if (isLoggedIn()) {
        return getUserData($_SESSION['user_uid']);
    }
    return null;
}

// ফাংশন: সেটিংস পাওয়া
function getSetting($key) {
    global $pdo;
    $stmt = $pdo->prepare("SELECT value FROM settings WHERE `key` = ?");
    $stmt->execute([$key]);
    $result = $stmt->fetch();
    return $result ? $result['value'] : null;
}

// ফাংশন: কমিশন রেট
function getCommissionRate() {
    $rate = getSetting('commission_rate');
    return $rate ? floatval($rate) : 0.006;
}

// ফাংশন: ব্যালেন্স আপডেট
function updateUserBalance($userId, $depositChange = 0, $winningChange = 0) {
    global $pdo;
    
    $sql = "UPDATE users SET 
            depositBalance = depositBalance + ?,
            winningBalance = winningBalance + ?
            WHERE id = ?";
    
    $stmt = $pdo->prepare($sql);
    return $stmt->execute([$depositChange, $winningChange, $userId]);
}

// ফাংশন: ট্রানজেকশন লগ
function logTransaction($userId, $type, $amount, $referenceId = null, $description = null) {
    global $pdo;
    
    // কারেন্ট ব্যালেন্স পাওয়া
    $user = getUserById($userId);
    if (!$user) return false;
    
    $balanceBefore = $user['depositBalance'] + $user['winningBalance'];
    $balanceAfter = $balanceBefore + $amount;
    
    $stmt = $pdo->prepare("
        INSERT INTO transactions 
        (user_id, type, amount, balance_before, balance_after, reference_id, description)
        VALUES (?, ?, ?, ?, ?, ?, ?)
    ");
    
    return $stmt->execute([
        $userId,
        $type,
        $amount,
        $balanceBefore,
        $balanceAfter,
        $referenceId,
        $description
    ]);
}

// এজেন্ট নাম্বার পাওয়া
function getAgentNumber($method) {
    $key = 'agent_' . strtolower($method);
    return getSetting($key) ?: '01700000001';
}

// VIP লেভেল ডাটা
$VIP_LEVELS = [
    ['level' => 0, 'min' => 0, 'salary' => 0],
    ['level' => 1, 'min' => 5000, 'salary' => 50],
    ['level' => 2, 'min' => 50000, 'salary' => 200],
    ['level' => 3, 'min' => 200000, 'salary' => 1000],
    ['level' => 4, 'min' => 500000, 'salary' => 3000],
    ['level' => 5, 'min' => 1000000, 'salary' => 7000],
    ['level' => 6, 'min' => 3000000, 'salary' => 20000],
    ['level' => 7, 'min' => 8000000, 'salary' => 50000],
    ['level' => 8, 'min' => 20000000, 'salary' => 150000],
    ['level' => 9, 'min' => 50000000, 'salary' => 400000],
    ['level' => 10, 'min' => 100000000, 'salary' => 1000000]
];

// গেম ডাটা
$GAMES = [
    '30s' => ['name' => 'Win Go 30s', 'time' => 30, 'db' => 'wingo30s'],
    '1m' => ['name' => 'Win Go 1m', 'time' => 60, 'db' => 'wingo1m'],
    '3m' => ['name' => 'Win Go 3m', 'time' => 180, 'db' => 'wingo3m'],
    '5m' => ['name' => 'Win Go 5m', 'time' => 300, 'db' => 'wingo5m'],
    '10m' => ['name' => 'Win Go 10m', 'time' => 600, 'db' => 'wingo10m'],
    '20m' => ['name' => 'Win Go 20m', 'time' => 1200, 'db' => 'wingo20m']
];

// স্লাইডার ডাটা
$sliderData = [
    ['img' => 'banner_1.webp', 'link' => '#'],
    ['img' => 'https://via.placeholder.com/600x300/ff0000/ffffff?text=Bonus', 'link' => '#/promotion']
];
?>